<?php

// Initialize the session
session_start();
include("../dbconnect.php");
include("../devlib.php");

function scrollDwn(){
    echo '<script>
         const elem = document.getElementById("sgn");
         elem.scrollIntoView();
         </script>
    ';
}

function sendMailConfirmation($rcode, $rmail){
    
    $psubject = "Confirm your email";
    $pmessage = "Please use the access code included in this email to validate your access at www.myprayerbook.org.\n Your access code: ".$rcode;
	$osmailheader = "From: palack@verizon\.net \r\n";
	
    if(mail($rmail, $psubject, $pmessage, $osmailheader)){
   
    }  
    
}

if($_SESSION['number'] >= 33){
    
   loadHeader();
   insertMenu();
   loadBanner();
   echo '<div class=""spacer-10"></div>
    <div class="container">
    <div class="row">
                <div class="col-lg-2"></div>
    
                <div class="col-lg-8 py-5">
                    <div style="width:100%; height:100%">
                       <p>Access denied.</p>
                    
                    </div>
                </div>
    
                <div class="col-lg-2"></div>
            </div>
    
    </div><div class="spacer-pg"></div>';
 
 
    loadFooter();
    exit();
} 

// Check if the user is already logged in, if yes then redirect him to welcome page
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){
    header("location: ../default1.php");
    exit;
}

// Define variables and initialize with empty values
$username = $password = "";
$username_err = $password_err = $login_err = "";


$login_err = "";

// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
 
    // Check if username is empty
    if(empty(trim($_POST["username"]))){
        $username_err = "Please enter username";
    } else{
        $username = trim($_POST["username"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST["password"]))){
        $password_err = "Please enter your password";
    } else{
        $password = trim($_POST["password"]);
    }
    
    // Validate credentials
    if(empty($username_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT UserId, UserName, UserPassword, UserDate, UserLevel, UserEmail, UserPwStatus FROM TUserAcc WHERE UserName = ?";
        
        if($stmt = mysqli_prepare($conlink, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_username);
            
            // Set parameters
            $param_username = $username;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);
                
                // Check if username exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){                    
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $id, $username, $hashed_password, $userdate, $userlevel, $uemail, $userpwstatus);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            // Password is correct
 
                           
                            $_SESSION["id"] = $id;
                            $_SESSION["username"] = $username; 
                        //    $_SESSION["userdate"] = $userdate;
                            $_SESSION["userlevel"] = $userlevel;
                            
                            if($userpwstatus == 1) {
                                $_SESSION["loggedin"] = true;
                                header("location: ../default1.php");
                            }
                            
                            //need confirmation
                            elseif ($userpwstatus ==2){
                                
                                  $pwcode = (string) rand(1000,9999);
                                  $_SESSION['passcode'] = $pwcode;
                                  sendMailConfirmation($pwcode, $uemail);
                                  
                                header("location: ../account/confirm.php");
                                exit;
                            }
                            
                            //need to be reset
                            else{
                                 header("location: ../account/reset.php");
                                 exit;
                            }
                     
                           
                        } else{
                            // Password is not valid, display a generic error message
                           $number = $_SESSION['number'];
                           $number++;
                           $_SESSION['number']= $number;       
                           $login_err = "*Invalid username or password.";
                         
                        }
                    }
                } else{
                    // Username doesn't exist, display a generic error message
                           $number = $_SESSION['number'];
                           $number++;
                           $_SESSION['number']= $number;       
                       
                          $login_err = "*User doesn't exist." ;
                
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    
    
    
}

loadHeader();
insertMenu();
loadBanner();

?>

        <main>
            <div class="container ">
                
                <div class="row">
                <div class="spacer-4"></div>
                    <div class="spacer-2"></div>
                  
                    <div class="col-sm-4">
                     
                    </div>
                    <div class="col-sm-4" id="sgn">
                        
                        <form class="form-signin"  action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">

                            <h1 class="h3 mb-3 fw-normal">Please sign in</h1>

                          <div class="form-floating py-1">
                                <input  type="text" name="username" id="fusername" class="form-control <?php echo (!empty($username_err)) ? 'is-invalid' : ''; ?>"
                                    value="<?php echo $username; ?>">
                                <span class="invalid-feedback"><?php echo $username_err; scrollDwn();?></span>
                                 <label for="fusername">Username</label>
                            </div>
                           <div class="form-floating py-1">
                             
                                <input type="password" id="fpassword" name="password" class="form-control <?php echo (!empty($password_err)) ? 'is-invalid' : ''; ?>">
                                <span class="invalid-feedback"><?php echo $password_err; scrollDwn();?></span> 
                                  <label for="fpassword">Password</label>
                            </div>

                            <button class="w-100 btn btn-lg btn-primary " type="submit">Sign in</button>

                        </form>
                    </div>
                   
                       
                      
                   
                    <div class="col-sm-4" ></div>
                </div>
                
                <div class="row py-3">
                     <div class="col-sm-5"></div>
                      <div class="col-sm-7 text-danger">
                         <?php if(!empty($login_err)) echo $login_err; scrollDwn();?>
                      </div>
                </div>
                <div class="row py-3">
                     <div class="col-sm-4 " ></div>
                      <div class="col-sm-4 ">
                          
                       Forgot your password? <a href="reset">Reset password</a>   <br/>
                       
                        Don't have an account? <a href="register">Sign up for new account</a>
                        
                      </div>
                      <div class="col-sm-4" ></div>
                </div>
                <div class="spacer-pg"></div>
            </div>
       
            <p></p>
            <!-- Footer-->
<?php 

loadFooter();

